###LOAD DEPENDENT PACKAGES
library(xlsx)
library(rstatix)
library(outliers)
library(ggplot2)
library(ggpubr)

###FORMAT DATA
Data <- read.xlsx("Discrete_Kinematics.xlsx", sheetIndex = 1)
Data[,4:23] <- abs(Data[,4:23])
Trunk <- Data[,c(1,19:23)]

###OUTLIER IDENTIFICATION

Ay.Trunk <- Trunk[1:30,]
Ma.Trunk <- Trunk[31:60,]
Ir.Trunk <- Trunk[61:90,]

#Grubb's test to identify outliers
#Aylesburys
for(i in 2:ncol(Ay.Trunk)){
  DV <- names(Ay.Trunk[i])
  res.grub <- grubbs.test(Ay.Trunk[,i], type = 11) #test if highest and lowest values are outliers
  print(DV)
  print(res.grub)
}
#Mallards
for(i in 2:ncol(Ma.Trunk)){
  DV <- names(Ma.Trunk[i])
  res.grub <- grubbs.test(Ma.Trunk[,i], type = 11) #test if highest and lowest values are outliers
  print(DV)
  print(res.grub)
}
#Runners
for(i in 2:ncol(Ir.Trunk)){
  DV <- names(Ir.Trunk[i])
  res.grub <- grubbs.test(Ir.Trunk[,i], type = 11) #test if highest and lowest values are outliers
  print(DV)
  print(res.grub)
}

#Boxplots to investigation data distribution

Box.Trunk.Max <- ggplot(Trunk, aes(x=Breed, y=Trunk_Max_Flex, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Maximum Trunk Pitch (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Box.Trunk.Min <- ggplot(Trunk, aes(x=Breed, y=Trunk_Min_Flex, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Minimum Trunk Pitch (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Box.Toe.On <- ggplot(Trunk, aes(x=Breed, y=Trunk_Toe_on, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Toe-on Trunk Pitch (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Box.Toe.Off <- ggplot(Trunk, aes(x=Breed, y=Trunk_Toe_off, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Toe-off Trunk Pitch (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Box.Mid.Stance <- ggplot(Trunk, aes(x=Breed, y=Trunk_Mid_Stance, fill=Breed)) + 
  geom_boxplot(width=0.8, lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Mid-stance Trunk Pitch (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

#combine and publish violin plots
tiff(filename = "Boxplot_Trunk.tif", width = 166, height = 166, units = "mm", res = 600, compression = "lzw") #166x166*2 or 166x166*1.5

plot.new()

ggarrange(Box.Trunk.Max, 
          Box.Trunk.Min, 
          Box.Toe.On, 
          Box.Toe.Off, 
          Box.Mid.Stance, 
          labels = c("A", "B", "C", "D", "E"),
          hjust = -4,
          ncol = 2, nrow = 3)

dev.off()

###MAIN ANALYSIS

#Seperate variables to individual columns (required as outliers are omitted via row deletion)
Trunk.Max.Flex.Data <- Trunk[,1:2]
Trunk.Min.Flex.Data <- Trunk[,c(1,3)]
Trunk.Toe.On.Data <- Trunk[,c(1,4)]
Trunk.Toe.Off.Data <- Trunk[,c(1,5)]
Trunk.Mid.Stance.Data <- Trunk[,c(1,6)]

#Omit outliers (currently performed manually)
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("32")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("37")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("38")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("39")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("42")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("47")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("49")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("50")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("54")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("55")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("53")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("56")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("57")),]
Trunk.Max.Flex.Data <- Trunk.Max.Flex.Data[!(row.names(Trunk.Max.Flex.Data) %in% c("60")),]

Trunk.Mid.Stance.Data <- Trunk.Mid.Stance.Data[!(row.names(Trunk.Mid.Stance.Data) %in% c("5")),]

#Shapiro-Wilks Test for Normality
res.shap <- shapiro_test(Trunk.Min.Flex.Data[,2])
print(res.shap)
res.shap <- shapiro_test(Trunk.Max.Flex.Data[,2])
print(res.shap)
res.shap <- shapiro_test(Trunk.Toe.On.Data[,2])
print(res.shap)
res.shap <- shapiro_test(Trunk.Toe.Off.Data[,2])
print(res.shap)
res.shap <- shapiro_test(Trunk.Mid.Stance.Data[,2])
print(res.shap)

#Levene's test for homogeneity of variance
res.lt <- levene_test(Trunk.Min.Flex.Data[,2] ~ Breed, data = Trunk.Min.Flex.Data)
print(res.lt)
res.lt <- levene_test(Trunk.Max.Flex.Data[,2] ~ Breed, data = Trunk.Max.Flex.Data)
print(res.lt)
res.lt <- levene_test(Trunk.Toe.On.Data[,2] ~ Breed, data = Trunk.Toe.On.Data)
print(res.lt)
res.lt <- levene_test(Trunk.Toe.Off.Data[,2] ~ Breed, data = Trunk.Toe.Off.Data)
print(res.lt)
res.lt <- levene_test(Trunk.Mid.Stance.Data[,2] ~ Breed, data = Trunk.Mid.Stance.Data)
print(res.lt)

#Kruskal-Wallis Test & output to .xls
KW.Trunk.Min.Flex <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Trunk.Min.Flex <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Trunk.Min.Flex.Data[,2] ~ Breed, data = Trunk.Min.Flex.Data)
res.ES <- kruskal_effsize(Trunk.Min.Flex.Data[,2] ~ Breed, data = Trunk.Min.Flex.Data)
print(res.KW)
print(res.ES)
KW.Trunk.Min.Flex[i,] <- data.frame(var = names(Trunk.Min.Flex.Data[2]), res.KW, row.names = NULL)
ES.Trunk.Min.Flex[i,] <- data.frame(var = names(Trunk.Min.Flex.Data[2]), res.ES, row.names = NULL)
colnames(KW.Trunk.Min.Flex) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Trunk.Min.Flex) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Trunk.Min.Flex <- cbind(KW.Trunk.Min.Flex, ES.Trunk.Min.Flex)
Final.Trunk.Min.Flex <- Final.Trunk.Min.Flex[ -c(2, 7:10, 12:13) ]
Final.Trunk.Min.Flex <- Final.Trunk.Min.Flex[ -c(1:5), ]

KW.Trunk.Max.Flex <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Trunk.Max.Flex <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Trunk.Max.Flex.Data[,2] ~ Breed, data = Trunk.Max.Flex.Data)
res.ES <- kruskal_effsize(Trunk.Max.Flex.Data[,2] ~ Breed, data = Trunk.Max.Flex.Data)
print(res.KW)
print(res.ES)
KW.Trunk.Max.Flex[i,] <- data.frame(var = names(Trunk.Max.Flex.Data[2]), res.KW, row.names = NULL)
ES.Trunk.Max.Flex[i,] <- data.frame(var = names(Trunk.Max.Flex.Data[2]), res.ES, row.names = NULL)
colnames(KW.Trunk.Max.Flex) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Trunk.Max.Flex) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Trunk.Max.Flex <- cbind(KW.Trunk.Max.Flex, ES.Trunk.Max.Flex)
Final.Trunk.Max.Flex <- Final.Trunk.Max.Flex[ -c(2, 7:10, 12:13) ]
Final.Trunk.Max.Flex <- Final.Trunk.Max.Flex[ -c(1:5), ]

KW.Trunk.Toe.On <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Trunk.Toe.On <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Trunk.Toe.On.Data[,2] ~ Breed, data = Trunk.Toe.On.Data)
res.ES <- kruskal_effsize(Trunk.Toe.On.Data[,2] ~ Breed, data = Trunk.Toe.On.Data)
print(res.KW)
print(res.ES)
KW.Trunk.Toe.On[i,] <- data.frame(var = names(Trunk.Toe.On.Data[2]), res.KW, row.names = NULL)
ES.Trunk.Toe.On[i,] <- data.frame(var = names(Trunk.Toe.On.Data[2]), res.ES, row.names = NULL)
colnames(KW.Trunk.Toe.On) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Trunk.Toe.On) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Trunk.Toe.On <- cbind(KW.Trunk.Toe.On, ES.Trunk.Toe.On)
Final.Trunk.Toe.On <- Final.Trunk.Toe.On[ -c(2, 7:10, 12:13) ]
Final.Trunk.Toe.On <- Final.Trunk.Toe.On[ -c(1:5), ]

KW.Trunk.Toe.Off <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Trunk.Toe.Off <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Trunk.Toe.Off.Data[,2] ~ Breed, data = Trunk.Toe.Off.Data)
res.ES <- kruskal_effsize(Trunk.Toe.Off.Data[,2] ~ Breed, data = Trunk.Toe.Off.Data)
print(res.KW)
print(res.ES)
KW.Trunk.Toe.Off[i,] <- data.frame(var = names(Trunk.Toe.Off.Data[2]), res.KW, row.names = NULL)
ES.Trunk.Toe.Off[i,] <- data.frame(var = names(Trunk.Toe.Off.Data[2]), res.ES, row.names = NULL)
colnames(KW.Trunk.Toe.Off) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Trunk.Toe.Off) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Trunk.Toe.Off <- cbind(KW.Trunk.Toe.Off, ES.Trunk.Toe.Off)
Final.Trunk.Toe.Off <- Final.Trunk.Toe.Off[ -c(2, 7:10, 12:13) ]
Final.Trunk.Toe.Off <- Final.Trunk.Toe.Off[ -c(1:5), ]

KW.Trunk.Mid.Stance <- data.frame(matrix(nrow = 2, ncol = 7))
ES.Trunk.Mid.Stance <- data.frame(matrix(nrow = 2, ncol = 6))
res.KW <- kruskal_test(Trunk.Mid.Stance.Data[,2] ~ Breed, data = Trunk.Mid.Stance.Data)
res.ES <- kruskal_effsize(Trunk.Mid.Stance.Data[,2] ~ Breed, data = Trunk.Mid.Stance.Data)
print(res.KW)
print(res.ES)
KW.Trunk.Mid.Stance[i,] <- data.frame(var = names(Trunk.Mid.Stance.Data[2]), res.KW, row.names = NULL)
ES.Trunk.Mid.Stance[i,] <- data.frame(var = names(Trunk.Mid.Stance.Data[2]), res.ES, row.names = NULL)
colnames(KW.Trunk.Mid.Stance) <- c("Parameter", "y", "n", "statistic", "df", "p", "method")
colnames(ES.Trunk.Mid.Stance) <- c("Parameter", "y", "n", "effsize", "method", "magnitude")
Final.Trunk.Mid.Stance <- cbind(KW.Trunk.Mid.Stance, ES.Trunk.Mid.Stance)
Final.Trunk.Mid.Stance <- Final.Trunk.Mid.Stance[ -c(2, 7:10, 12:13) ]
Final.Trunk.Mid.Stance <- Final.Trunk.Mid.Stance[ -c(1:5), ]

write.xlsx(Final.Trunk.Min.Flex, file = "KW_Trunk.xlsx", sheetName = "Trunk.Min.Flex")
write.xlsx(Final.Trunk.Max.Flex, file = "KW_Trunk.xlsx", sheetName = "Trunk.Max.Flex", append = TRUE)
write.xlsx(Final.Trunk.Toe.On, file = "KW_Trunk.xlsx", sheetName = "Trunk.Toe.On", append = TRUE)
write.xlsx(Final.Trunk.Toe.Off, file = "KW_Trunk.xlsx", sheetName = "Trunk.Toe.Off", append = TRUE)
write.xlsx(Final.Trunk.Mid.Stance, file = "KW_Trunk.xlsx", sheetName = "Trunk.Mid.Stance", append = TRUE)

#Dunn's Test & output to .xls
dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Trunk.Min.Flex <- dunn_vector(Trunk.Min.Flex.Data, reformulate("Breed", names(Trunk.Min.Flex.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Trunk.Min.Flex

dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Trunk.Max.Flex <- dunn_vector(Trunk.Max.Flex.Data, reformulate("Breed", names(Trunk.Max.Flex.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Trunk.Max.Flex

dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Trunk.Toe.On <- dunn_vector(Trunk.Toe.On.Data, reformulate("Breed", names(Trunk.Toe.On.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Trunk.Toe.On

dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Trunk.Toe.Off <- dunn_vector(Trunk.Toe.Off.Data, reformulate("Breed", names(Trunk.Toe.Off.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Trunk.Toe.Off

dunn_vector <- Vectorize(dunn_test, vectorize.args="formula", SIMPLIFY=F)
reformulate <- Vectorize(reformulate, vectorize.args="response")
DN.Trunk.Mid.Stance <- dunn_vector(Trunk.Mid.Stance.Data, reformulate("Breed", names(Trunk.Mid.Stance.Data)[2]), p.adjust.method="bonferroni") #2:15 for linear measurements 2:11 for hulls
DN.Trunk.Mid.Stance

write.xlsx(DN.Trunk.Min.Flex, file = "Dunn_Trunk.xlsx", sheetName = "Trunk.Min.Flex")
write.xlsx(DN.Trunk.Max.Flex, file = "Dunn_Trunk.xlsx", sheetName = "Trunk.Max.Flex", append = TRUE)
write.xlsx(DN.Trunk.Toe.On, file = "Dunn_Trunk.xlsx", sheetName = "Trunk.Toe.On", append = TRUE)
write.xlsx(DN.Trunk.Toe.Off, file = "Dunn_Trunk.xlsx", sheetName = "Trunk.Toe.Off", append = TRUE)
write.xlsx(DN.Trunk.Mid.Stance, file = "Dunn_Trunk.xlsx", sheetName = "Trunk.Mid.Stance", append = TRUE)

#Violin Plots
Violin.Trunk.Min.Flex <- ggplot(Trunk.Min.Flex.Data, aes(x=Breed, y=Trunk_Min_Flex, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Minimum Trunk Pitch (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Violin.Trunk.Max.Flex <- ggplot(Trunk.Max.Flex.Data, aes(x=Breed, y=Trunk_Max_Flex, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Maximum Trunk Pitch (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Violin.Trunk.Toe.On <- ggplot(Trunk.Toe.On.Data, aes(x=Breed, y=Trunk_Toe_on, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Toe-on Trunk Pitch (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Violin.Trunk.Toe.Off <- ggplot(Trunk.Toe.Off.Data, aes(x=Breed, y=Trunk_Toe_off, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Toe-off Trunk Pitch (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

Violin.Trunk.Mid.Stance <- ggplot(Trunk.Mid.Stance.Data, aes(x=Breed, y=Trunk_Mid_Stance, fill=Breed)) + 
  geom_violin(trim = TRUE, lwd=1) +
  geom_boxplot(width=0.05, fill="white", lwd=1) +
  scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
  labs(x = "Breed", y = "Mid-stance Trunk Flexion (\u00B0)") +
  theme(legend.position="none") +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

#combine and publish violin plots
tiff(filename = "Violin_Trunk.tif", width = 166, height = 166, units = "mm", res = 600, compression = "lzw") #166x166*2 or 166x166*1.5

plot.new()

ggarrange(Violin.Trunk.Min.Flex, 
          Violin.Trunk.Max.Flex, 
          Violin.Trunk.Toe.On, 
          Violin.Trunk.Toe.Off, 
          Violin.Trunk.Mid.Stance, 
          labels = c("A", "B", "C", "D", "E"),
          hjust = -4,
          ncol = 2, nrow = 3)

dev.off()